/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;

public class ChannelFiller
extends ReaderWrapper {
    public ChannelFiller() {
    }

    public ChannelFiller(IFormatReader r) {
        super(r);
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isFalseColor() {
        return false;
    }

    public byte[][] get8BitLookupTable() {
        try {
            return this.reader.isFalseColor() ? this.reader.get8BitLookupTable() : (byte[][])null;
        }
        catch (FormatException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public short[][] get16BitLookupTable() {
        try {
            return this.reader.isFalseColor() ? this.reader.get16BitLookupTable() : (short[][])null;
        }
        catch (FormatException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        if (this.reader.isIndexed() && !this.reader.isFalseColor()) {
            if (this.getPixelType() == 1) {
                byte[][] b = ImageTools.indexedToRGB(this.reader.get8BitLookupTable(), this.reader.openBytes(no));
                byte[] rtn = new byte[b.length * b[0].length];
                if (this.isInterleaved()) {
                    int pt = 0;
                    for (int i = 0; i < b[0].length; ++i) {
                        for (int j = 0; j < b.length; ++j) {
                            rtn[pt++] = b[j][i];
                        }
                    }
                } else {
                    for (int i = 0; i < b.length; ++i) {
                        System.arraycopy(b[i], 0, rtn, i * b[i].length, b[i].length);
                    }
                }
                return rtn;
            }
            short[][] s2 = ImageTools.indexedToRGB(this.reader.get16BitLookupTable(), this.reader.openBytes(no), this.isLittleEndian());
            byte[] rtn = new byte[s2.length * s2[0].length * 2];
            if (this.isInterleaved()) {
                int pt = 0;
                for (int i = 0; i < s2[0].length; ++i) {
                    for (int j = 0; j < s2.length; ++j) {
                        rtn[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] & 0xFF : s2[j][i] >> 8);
                        rtn[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] >> 8 : s2[j][i] & 0xFF);
                    }
                }
            } else {
                int pt = 0;
                for (int i = 0; i < s2.length; ++i) {
                    for (int j = 0; j < s2[i].length; ++j) {
                        rtn[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] & 0xFF : s2[j][i] >> 8);
                        rtn[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] >> 8 : s2[j][i] & 0xFF);
                    }
                }
            }
            return rtn;
        }
        return this.reader.openBytes(no);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        if (this.reader.isIndexed() && !this.reader.isFalseColor()) {
            return ImageTools.indexedToRGB(this.reader.openImage(no), this.isLittleEndian());
        }
        return this.reader.openImage(no);
    }
}

