/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribDataReader;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.nc2.util.cache.SmartArrayInt;
import ucar.unidata.io.RandomAccessFile;

public abstract class PartitionCollectionImmutable
extends GribCollectionImmutable {
    private static final Logger logger = LoggerFactory.getLogger(PartitionCollectionImmutable.class);
    public static int countPC;
    static final FileFactory partitionCollectionFactory;
    private final List<Partition> partitions;
    private final boolean isPartitionOfPartitions;
    private final int[] run2part;

    PartitionCollectionImmutable(PartitionCollectionMutable pc) {
        super(pc);
        List<PartitionCollectionMutable.Partition> pcParts = pc.partitions;
        ArrayList<Partition> work = new ArrayList<Partition>(pcParts.size());
        for (PartitionCollectionMutable.Partition pcPart : pcParts) {
            work.add(new Partition(pcPart));
        }
        this.partitions = Collections.unmodifiableList(work);
        this.isPartitionOfPartitions = pc.isPartitionOfPartitions;
        this.run2part = pc.run2part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GribCollectionImmutable getLatestGribCollection(List<String> paths) throws IOException {
        Partition last = this.partitions.get(this.partitions.size() - 1);
        paths.add(last.getName());
        GribCollectionImmutable gc = last.getGribCollection();
        if (gc instanceof PartitionCollectionImmutable) {
            try {
                PartitionCollectionImmutable pc = (PartitionCollectionImmutable)gc;
                GribCollectionImmutable gribCollectionImmutable = pc.getLatestGribCollection(paths);
                return gribCollectionImmutable;
            }
            finally {
                gc.close();
            }
        }
        return gc;
    }

    @Override
    protected GribCollectionImmutable.VariableIndex makeVariableIndex(GribCollectionImmutable.GroupGC group, GribCollectionMutable.VariableIndex mutableVar) {
        return new VariableIndexPartitioned(group, mutableVar);
    }

    public Iterable<Partition> getPartitions() {
        return this.partitions;
    }

    public Partition getPartition(int idx) {
        return this.partitions.get(idx);
    }

    public Partition getPartitionByName(String name) {
        for (Partition p : this.partitions) {
            if (!p.name.equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public boolean isPartitionOfPartitions() {
        return this.isPartitionOfPartitions;
    }

    public int getPartitionSize() {
        return this.partitions.size();
    }

    public List<Partition> getPartitionsSorted() {
        ArrayList<Partition> c = new ArrayList<Partition>(this.partitions);
        Collections.sort(c);
        if (!this.config.getSortFilesAscending()) {
            Collections.reverse(c);
        }
        return c;
    }

    public VariableIndexPartitioned getVariable2DByHash(GribHorizCoordSystem hcs, GribCollectionImmutable.VariableIndex vi) {
        GribCollectionImmutable.Dataset ds2d = this.getDatasetCanonical();
        if (ds2d == null) {
            return null;
        }
        for (GribCollectionImmutable.GroupGC groupHcs : ds2d.getGroups()) {
            if (!groupHcs.getGdsHash().equals(hcs.getGdsHash())) continue;
            return (VariableIndexPartitioned)groupHcs.findVariableByHash(vi);
        }
        return null;
    }

    @Override
    public void showIndex(Formatter f) {
        super.showIndex(f);
        f.format("%nPartition isPartitionOfPartitions = %s%n", this.isPartitionOfPartitions);
        for (Partition p : this.partitions) {
            f.format("  %s%n", p);
        }
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartition(partno);
        try (GribCollectionImmutable gc = part.getGribCollection();){
            RandomAccessFile randomAccessFile = gc.getDataRaf(fileno);
            return randomAccessFile;
        }
    }

    public String getFilename(int partno, int fileno) throws IOException {
        Partition part = this.getPartition(partno);
        try (GribCollectionImmutable gc = part.getGribCollection();){
            String string = gc.getFilename(fileno);
            return string;
        }
    }

    static {
        partitionCollectionFactory = new FileFactory(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public FileCacheable open(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                try (RandomAccessFile raf = RandomAccessFile.acquire(durl.trueurl);){
                    Partition p = (Partition)iospMessage;
                    GribCollectionImmutable gribCollectionImmutable = GribCdmIndex.openGribCollectionFromIndexFile(raf, p.getConfig(), p.getLogger());
                    return gribCollectionImmutable;
                }
                catch (Throwable t) {
                    RandomAccessFile.eject(durl.trueurl);
                    throw t;
                }
            }
        };
    }

    @Immutable
    class DataRecord
    extends GribDataReader.DataRecord {
        final PartitionCollectionImmutable usePartition;
        final int partno;

        DataRecord(PartitionCollectionImmutable usePartition, int partno, GdsHorizCoordSys hcs, GribCollectionImmutable.Record record) {
            super(-1, record, hcs);
            this.usePartition = usePartition;
            this.partno = partno;
        }

        @Override
        public int compareTo(GribDataReader.DataRecord o) {
            DataRecord op = (DataRecord)o;
            int rp = this.usePartition.getName().compareTo(op.usePartition.getName());
            if (rp != 0) {
                return rp;
            }
            int r = Misc.compare(this.partno, op.partno);
            if (r != 0) {
                return r;
            }
            r = Misc.compare(this.record.fileno, o.record.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare(this.record.pos, o.record.pos);
        }

        public boolean usesSameFile(DataRecord o) {
            if (o == null) {
                return false;
            }
            int rp = this.usePartition.getName().compareTo(o.usePartition.getName());
            if (rp != 0) {
                return false;
            }
            int r = Misc.compare(this.partno, o.partno);
            if (r != 0) {
                return false;
            }
            r = Misc.compare(this.record.fileno, o.record.fileno);
            return r == 0;
        }

        public void show() throws IOException {
            String dataFilename = this.usePartition.getFilename(this.partno, this.record.fileno);
            System.out.printf(" **DataReader partno=%d fileno=%d filename=%s startPos=%d%n", this.partno, this.record.fileno, dataFilename, this.record.pos);
        }
    }

    @Immutable
    public class VariableIndexPartitioned
    extends GribCollectionImmutable.VariableIndex {
        final int nparts;
        final SmartArrayInt partnoSA;
        final SmartArrayInt groupnoSA;
        final SmartArrayInt varnoSA;

        VariableIndexPartitioned(GribCollectionImmutable.GroupGC g2, GribCollectionMutable.VariableIndex other) {
            super(PartitionCollectionImmutable.this, g2, other);
            PartitionCollectionMutable.VariableIndexPartitioned pother = (PartitionCollectionMutable.VariableIndexPartitioned)other;
            this.nparts = pother.nparts;
            this.partnoSA = pother.partnoSA;
            this.groupnoSA = pother.groupnoSA;
            this.varnoSA = pother.varnoSA;
        }

        public int getNparts() {
            return this.nparts;
        }

        public GribCollectionImmutable.Type getType() {
            return this.group.ds.gctype;
        }

        public void show(Formatter sb) {
            sb.format("VariableIndexPartitioned%n", new Object[0]);
            sb.format(" partno=", new Object[0]);
            this.partnoSA.show(sb);
            sb.format("%n groupno=", new Object[0]);
            this.groupnoSA.show(sb);
            sb.format("%n varno=", new Object[0]);
            this.varnoSA.show(sb);
            sb.format("%n", new Object[0]);
            int count = 0;
            sb.format("     %7s %3s %3s %6s %3s%n", "N", "dups", "Miss", "density", "partition");
            for (int i = 0; i < this.nparts; ++i) {
                int partWant = this.partnoSA.get(i);
                Partition part = (Partition)PartitionCollectionImmutable.this.partitions.get(partWant);
                sb.format("   %2d: %7d %s%n", count++, partWant, part.getFilename());
            }
            sb.format("%n", new Object[0]);
        }

        DataRecord getDataRecord(int[] indexWanted) throws IOException {
            int masterIdx;
            Object val;
            if (Grib.debugRead) {
                System.out.printf("%nPartitionCollection.getDataRecord index wanted = (%s) on %s type=%s%n", new Object[]{Misc.showInts(indexWanted), PartitionCollectionImmutable.this.indexFilename, this.group.ds.gctype});
            }
            int firstIndex = indexWanted[0];
            if (this.group.ds.gctype == GribCollectionImmutable.Type.TwoD) {
                CoordinateRuntime runtime = (CoordinateRuntime)this.getCoordinate(Coordinate.Type.runtime);
                val = runtime.getValue(firstIndex);
                masterIdx = PartitionCollectionImmutable.this.masterRuntime.getIndex(val);
                if (Grib.debugRead) {
                    System.out.printf("  TwoD firstIndex = %d val=%s masterIdx=%d %n", firstIndex, val, masterIdx);
                }
            } else if (this.group.ds.gctype == GribCollectionImmutable.Type.Best) {
                CoordinateTimeAbstract time = this.getCoordinateTime();
                masterIdx = time.getMasterRuntimeIndex(firstIndex) - 1;
                if (Grib.debugRead) {
                    System.out.printf("  Best firstIndex = %d masterIdx=%d %n", firstIndex, masterIdx);
                }
            } else if (this.group.ds.gctype == GribCollectionImmutable.Type.MRUTP) {
                CoordinateTime2D time2D = (CoordinateTime2D)this.getCoordinateTime();
                val = time2D.getRefDate(firstIndex);
                masterIdx = PartitionCollectionImmutable.this.masterRuntime.getIndex(val);
                if (Grib.debugRead) {
                    System.out.printf("  MRUTP firstIndex = %d masterIdx=%d %n", firstIndex, masterIdx);
                }
            } else {
                throw new IllegalStateException("Unknown gctype= " + (Object)((Object)this.group.ds.gctype) + " on " + PartitionCollectionImmutable.this.indexFilename);
            }
            int partno = PartitionCollectionImmutable.this.run2part[masterIdx];
            if (partno < 0) {
                return null;
            }
            GribCollectionImmutable.VariableIndex vindex2Dpart = this.getVindex2D(partno);
            if (vindex2Dpart == null) {
                return null;
            }
            if (Grib.debugRead) {
                System.out.printf("  compVindex2D = %s%n", vindex2Dpart.toStringFrom());
            }
            if (PartitionCollectionImmutable.this.isPartitionOfPartitions) {
                VariableIndexPartitioned compVindex2Dp = (VariableIndexPartitioned)vindex2Dpart;
                return this.getDataRecordPofP(indexWanted, compVindex2Dp);
            }
            int[] sourceIndex = this.group.getType() == GribCollectionImmutable.Type.Best ? this.translateIndexBest(indexWanted, vindex2Dpart) : this.translateIndex2D(indexWanted, vindex2Dpart);
            if (sourceIndex == null) {
                return null;
            }
            GribCollectionImmutable.Record record = vindex2Dpart.getRecordAt(sourceIndex);
            if (record == null) {
                return null;
            }
            if (Grib.debugRead) {
                System.out.printf("  result success: partno=%d fileno=%d %n", partno, record.fileno);
            }
            return new DataRecord(PartitionCollectionImmutable.this, partno, vindex2Dpart.group.getGdsHorizCoordSys(), record);
        }

        private DataRecord getDataRecordPofP(int[] indexWanted, VariableIndexPartitioned compVindex2Dp) throws IOException {
            if (this.group.getType() == GribCollectionImmutable.Type.Best) {
                int[] indexWantedP = this.translateIndexBest(indexWanted, compVindex2Dp);
                if (Grib.debugRead) {
                    System.out.printf("  (Best) getDataRecordPofP= %s %n", Misc.showInts(indexWantedP));
                }
                if (indexWantedP == null) {
                    return null;
                }
                return compVindex2Dp.getDataRecord(indexWantedP);
            }
            int[] indexWantedP = this.translateIndex2D(indexWanted, compVindex2Dp);
            if (Grib.debugRead) {
                System.out.printf("  (2D) getDataRecordPofP= %s %n", Misc.showInts(indexWantedP));
            }
            if (indexWantedP == null) {
                return null;
            }
            return compVindex2Dp.getDataRecord(indexWantedP);
        }

        private GribCollectionImmutable.VariableIndex getVindex2D(int partno) throws IOException {
            VariableIndexPartitioned vip;
            VariableIndexPartitioned variableIndexPartitioned = vip = PartitionCollectionImmutable.this.isPartitionOfPartitions ? PartitionCollectionImmutable.this.getVariable2DByHash(this.group.horizCoordSys, this) : this;
            if (vip == null) {
                throw new IllegalStateException();
            }
            int partWant = vip.partnoSA.findIdx(partno);
            if (partWant < 0 || partWant >= vip.nparts) {
                if (Grib.debugRead) {
                    System.out.printf("  cant find partition=%d in vip=%s%n", partno, vip);
                }
                return null;
            }
            Partition p = PartitionCollectionImmutable.this.getPartition(partno);
            try (GribCollectionImmutable gc = p.getGribCollection();){
                GribCollectionImmutable.Dataset ds = gc.getDatasetCanonical();
                GribCollectionImmutable.GroupGC g2 = ds.groups.get(vip.groupnoSA.get(partWant));
                GribCollectionImmutable.VariableIndex vindex = g2.variList.get(vip.varnoSA.get(partWant));
                vindex.readRecords();
                GribCollectionImmutable.VariableIndex variableIndex = vindex;
                return variableIndex;
            }
        }

        private int[] translateIndexBest(int[] wholeIndex, GribCollectionImmutable.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length + 1];
            int timeIdx = wholeIndex[0];
            CoordinateTimeAbstract time = this.getCoordinateTime();
            assert (time != null);
            int masterIdx = time.getMasterRuntimeIndex(timeIdx) - 1;
            int runtimeIdxPart = this.matchCoordinate(PartitionCollectionImmutable.this.masterRuntime, masterIdx, compVindex2D.getCoordinate(0));
            if (runtimeIdxPart < 0) {
                return null;
            }
            result[0] = runtimeIdxPart;
            for (int countDim = 0; countDim < wholeIndex.length; ++countDim) {
                int resultIdx;
                Coordinate wholeCoord1D = this.getCoordinate(countDim);
                int idx = wholeIndex[countDim];
                Coordinate compCoord = compVindex2D.getCoordinate(countDim + 1);
                if (compCoord.getType() == Coordinate.Type.time2D) {
                    CoordinateTime2D compCoord2D = (CoordinateTime2D)compCoord;
                    CoordinateTimeAbstract wholeCoord1Dtime = (CoordinateTimeAbstract)wholeCoord1D;
                    Object wholeVal1D = wholeCoord1D.getValue(idx);
                    if (wholeVal1D == null) {
                        return null;
                    }
                    CoordinateTime2D.Time2D wholeVal2D = compCoord2D.isTimeInterval() ? new CoordinateTime2D.Time2D(wholeCoord1Dtime.getRefDate(), null, (TimeCoord.Tinv)wholeVal1D) : new CoordinateTime2D.Time2D(wholeCoord1Dtime.getRefDate(), (Integer)wholeVal1D, null);
                    resultIdx = compCoord2D.matchTimeCoordinate(runtimeIdxPart, wholeVal2D);
                } else {
                    resultIdx = this.matchCoordinate(wholeCoord1D, idx, compCoord);
                }
                if (resultIdx < 0) {
                    return null;
                }
                result[countDim + 1] = resultIdx;
            }
            return result;
        }

        private int[] translateIndex2D(int[] wholeIndex, GribCollectionImmutable.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length];
            int countDim = 0;
            CoordinateTime2D compTime2D = (CoordinateTime2D)compVindex2D.getCoordinate(Coordinate.Type.time2D);
            if (compTime2D != null) {
                CoordinateTime2D time2D = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
                CoordinateTime2D.Time2D want = time2D.getOrgValue(wholeIndex[0], wholeIndex[1]);
                if (Grib.debugRead) {
                    System.out.printf("  translateIndex2D[runIdx=%d, timeIdx=%d] in componentVar coords = (%s,%s) %n", wholeIndex[0], wholeIndex[1], want == null ? "null" : want.getRefDate(), want);
                }
                if (want == null) {
                    return null;
                }
                if (!compTime2D.getIndex(want, result)) {
                    return null;
                }
                countDim = 2;
            }
            while (countDim < wholeIndex.length) {
                int idx = wholeIndex[countDim];
                int resultIdx = this.matchCoordinate(this.getCoordinate(countDim), idx, compVindex2D.getCoordinate(countDim));
                if (Grib.debugRead) {
                    System.out.printf("  translateIndex2D[idx=%d] resultIdx= %d %n", idx, resultIdx);
                }
                if (resultIdx < 0) {
                    return null;
                }
                result[countDim] = resultIdx;
                ++countDim;
            }
            return result;
        }

        private int matchCoordinate(Coordinate whole, int wholeIdx, Coordinate part) {
            Object val = whole.getValue(wholeIdx);
            if (val == null) {
                return -1;
            }
            return part.getIndex(val);
        }

        DataRecord getDataRecord(SubsetParams coords) throws IOException {
            CalendarDate runtime = coords.getRunTime();
            int masterIdx = PartitionCollectionImmutable.this.masterRuntime.getIndex(runtime.getMillis());
            if (masterIdx < 0) {
                throw new RuntimeException("masterRuntime does not contain runtime " + runtime);
            }
            int partno = PartitionCollectionImmutable.this.run2part[masterIdx];
            if (partno < 0) {
                return null;
            }
            GribCollectionImmutable.VariableIndex compVindex2D = this.getVindex2D(partno);
            if (compVindex2D == null) {
                return null;
            }
            if (Grib.debugRead) {
                System.out.printf("  compVindex2D = %s%n", compVindex2D.toStringFrom());
            }
            if (PartitionCollectionImmutable.this.isPartitionOfPartitions) {
                VariableIndexPartitioned compVindex2Dp = (VariableIndexPartitioned)compVindex2D;
                return compVindex2Dp.getDataRecord(coords);
            }
            GribCollectionImmutable.Record record = compVindex2D.getRecordAt(coords);
            if (record == null) {
                return null;
            }
            if (Grib.debugRead) {
                System.out.printf("  result success: partno=%d fileno=%d %n", partno, record.fileno);
            }
            DataRecord dr = new DataRecord(PartitionCollectionImmutable.this, partno, compVindex2D.group.getGdsHorizCoordSys(), record);
            if (GribDataReader.validator != null) {
                dr.validation = coords;
            }
            return dr;
        }
    }

    @Immutable
    public class Partition
    implements Comparable<Partition> {
        private final String name;
        private final String filename;
        private final long lastModified;
        private final long fileSize;
        private final CalendarDate partitionDate;

        public Partition(PartitionCollectionMutable.Partition pcPart) {
            this.name = pcPart.name;
            this.filename = pcPart.filename;
            this.lastModified = pcPart.lastModified;
            this.fileSize = pcPart.fileSize;
            this.partitionDate = pcPart.partitionDate;
        }

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean isGrib1() {
            return PartitionCollectionImmutable.this.isGrib1;
        }

        public FeatureCollectionConfig getConfig() {
            return PartitionCollectionImmutable.this.config;
        }

        public Logger getLogger() {
            return logger;
        }

        public String getIndexFilenameInCache() throws FileNotFoundException {
            File file = new File(PartitionCollectionImmutable.this.directory, this.filename);
            File existingFile = GribIndexCache.getExistingFileOrCache(file.getPath());
            if (existingFile == null) {
                throw new FileNotFoundException("No index filename for partition= " + this.toString() + " looking for " + file.getPath());
            }
            return existingFile.getPath();
        }

        public GribCollectionImmutable getGribCollection() throws IOException {
            String path = this.getIndexFilenameInCache();
            return GribCdmIndex.acquireGribCollection(partitionCollectionFactory, path, path, -1, null, this);
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{ " + this.name + '\'' + ", filename='" + this.filename + '\'' + ", partitionDate='" + this.partitionDate + '\'' + ", lastModified='" + CalendarDate.of(this.lastModified) + '\'' + ", fileSize='" + this.fileSize + '\'' + '}';
        }
    }
}

