/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class FnmocTables
extends Grib1Customizer {
    private static final Logger logger = LoggerFactory.getLogger(FnmocTables.class);
    private static Map<Integer, GribLevelType> levelTypesMap;
    private static Map<Integer, String> genProcessMap;

    FnmocTables(Grib1ParamTables tables) {
        super(58, tables);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            genProcessMap = this.readGenProcess("resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterModelTableOrdered.GRIB1.TblA.xml");
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, String> readGenProcess(String path) {
        try (InputStream is = GribResourceReader.getInputStream(path);){
            if (is == null) {
                logger.error("Cant find FNMOC gen process table = " + path);
                Map<Integer, String> map2 = null;
                return map2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                String desc = elem1.getChildText("fullName");
                result.put(code, desc);
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        catch (IOException ioe) {
            logger.error("Cant read FNMOC Table 1 = " + path, ioe);
            return null;
        }
        catch (JDOMException e) {
            logger.error("Cant parse FNMOC Table 1 = " + path, e);
        }
        return null;
    }

    @Override
    protected GribLevelType getLevelType(int code) {
        if (code < 199) {
            return super.getLevelType(code);
        }
        if (levelTypesMap == null) {
            levelTypesMap = this.readFnmocTable3("resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterLevelTypeTableOrdered.GRIB1.Tbl3.xml");
        }
        if (levelTypesMap == null) {
            return super.getLevelType(code);
        }
        GribLevelType levelType = levelTypesMap.get(code);
        if (levelType != null) {
            return levelType;
        }
        return super.getLevelType(code);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<Integer, GribLevelType> readFnmocTable3(String path) {
        try (InputStream is = GribResourceReader.getInputStream(path);){
            if (is == null) {
                logger.error("Cant find FnmocTable3 = " + path);
                HashMap<Integer, GribLevelType> hashMap2 = null;
                return hashMap2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, GribLevelType> result = new HashMap<Integer, GribLevelType>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                if (code < 129) continue;
                String desc = elem1.getChildText("description");
                String abbrev = elem1.getChildText("name");
                String units = elem1.getChildText("units");
                if (units == null) {
                    units = this.makeUnits(code);
                }
                String datum = elem1.getChildText("datum");
                boolean isLayer = elem1.getChild("isLayer") != null;
                boolean isPositiveUp = elem1.getChild("isPositiveUp") != null;
                GribLevelType lt = new GribLevelType(code, desc, abbrev, units, datum, isPositiveUp, isLayer);
                result.put(code, lt);
            }
            HashMap<Integer, GribLevelType> hashMap = result;
            return hashMap;
        }
        catch (IOException ioe) {
            logger.error("Cant read FnmocTable3 = " + path, ioe);
            return null;
        }
        catch (JDOMException e) {
            logger.error("Cant parse FnmocTable3 = " + path, e);
            return null;
        }
    }

    private String makeUnits(int code) {
        switch (code) {
            case 219: {
                return "Pa";
            }
        }
        return "";
    }
}

