/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math;

import Jama.Matrix;

public class ColumnVector
extends Matrix {
    public ColumnVector(Matrix mat) {
        this(mat.getRowDimension());
        int i = 0;
        while (i < this.getRowDimension()) {
            this.set(i, mat.get(i, 0));
            ++i;
        }
    }

    public ColumnVector(double[] V, int n) {
        this(n);
        int i = 0;
        while (i < n) {
            this.set(i, V[i]);
            ++i;
        }
    }

    public ColumnVector(int n) {
        super(n, 1);
    }

    public double get(int i) {
        return this.get(i, 0);
    }

    public void set(int i, double val) {
        this.set(i, 0, val);
    }

    public double dotProduct(ColumnVector ColVec) {
        return this.transpose().times((Matrix)ColVec).get(0, 0);
    }

    public double length() {
        return Math.sqrt(this.dotProduct(this));
    }
}

