/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.AttributeData;
import org.n52.operation.cropmodeling.CGMSWeatherData;
import org.n52.operation.cropmodeling.ClassicDriessenKonijnWeatherData;
import org.n52.operation.cropmodeling.DayWeatherData;
import org.n52.operation.cropmodeling.GridWeatherData;
import org.n52.operation.cropmodeling.GrowthParameters;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.SpatialLocationCell;
import org.n52.operation.cropmodeling.TimeTemperature;
import org.n52.operation.cropmodeling.WageningenWeatherData;

public class WeatherData
extends AttributeData {
    protected double latitude;
    protected double longitude;
    protected String outputName;
    protected boolean useRealData = false;

    public DayWeatherData getDayWeatherData(JulianTime time) {
        return (DayWeatherData)this.attributes.get(time.getHalfDayIndex());
    }

    public void setDayWeatherData(JulianTime time, DayWeatherData newData) {
        this.attributes.put(time.getHalfDayIndex(), newData);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    TimeTemperature[] getTemperatures(JulianTime now) {
        return null;
    }

    void writeData(JulianTime time, Object data) {
    }

    static WeatherData create(GrowthParameters gp, SpatialLocationCell cell) {
        String source = gp.getWeatherDataSourceType();
        if (source.equalsIgnoreCase("CGMS")) {
            return new CGMSWeatherData(Integer.parseInt(cell.toString()), gp.getWeatherDataSource());
        }
        if (source.equalsIgnoreCase("Driessen&Konijn")) {
            return new ClassicDriessenKonijnWeatherData(gp.getWeatherDataSource());
        }
        if (source.equalsIgnoreCase("Wageningen")) {
            return new WageningenWeatherData(gp.getYear(), gp.getWeatherDataSource());
        }
        if (source.equalsIgnoreCase("Grid")) {
            return new GridWeatherData();
        }
        return null;
    }

    void Update() {
    }

    JulianTime getBeginMeasurements() {
        return null;
    }

    JulianTime getEndMeasurements() {
        return null;
    }

    double[] getDailyDiffuseRadiations(JulianTime now) {
        return null;
    }

    double[] getDailyDirectRadiations(JulianTime now) {
        return null;
    }

    double getWindSpeed(double hour, double daylength, double dwdsa) {
        double wdsrng = 0.66;
        double srhour = hour + 12.0 + 0.5 * daylength % 24.0;
        double sshour = srhour - daylength;
        if (srhour >= 0.1 && srhour < daylength + 2.0) {
            return dwdsa * (1.0 - 0.44 * wdsrng + wdsrng * Math.sin((srhour - 1.0) * Math.PI / (daylength + 1.0)));
        }
        return dwdsa * (1.0 - 0.44 * wdsrng);
    }

    double getCurrentTemperatureFromData(JulianTime time) {
        return -273.15;
    }

    public void setOutputDataTable(String newName) {
        this.outputName = newName;
    }

    public boolean isUseRealData() {
        return this.useRealData;
    }

    public void setUseRealData(boolean useRealData) {
        this.useRealData = useRealData;
    }
}

