@echo off
rem loop through all 20 seconds GLM nc files and extract 3 parameter
rem parameters extracted are flash_id, flash_lat, flash_lon and flash_energy
rem the file is transposed using datamash
rem subsequently the first 2 lines are deleted
rem finally the last 3 lines are deleted

set ncfilename=%1
set ncshortfilename1=%ncfilename:~27,7%

echo.
rem echo Current time stamp processed = %ncfilename%
echo Current time stamp processed hhmmss = %ncshortfilename1:~0,-1%
echo.

call inputparam.bat

"%UtilDir%\netCDF_474\bin\ncdump.exe" -l 1000000 -v flash_id,flash_lat,flash_lon,flash_energy %ncfilename%>out%ncshortfilename1%.txt 


cmd /c findstr /g:pattern.txt out%ncshortfilename1%.txt>out4p%ncshortfilename1%.txt

%UtilDir%\datamash.exe -W transpose < out4p%ncshortfilename1%.txt>GLM%ncshortfilename1%_temp.txt

rem delete first 2 lines from txt file
cmd /c more +2 GLM%ncshortfilename1%_temp.txt>GLM%ncshortfilename1%.txt

@echo OFF
setlocal EnableDelayedExpansion

set LINES=0
for /f "delims==" %%I in (GLM%ncshortfilename1%.txt) do (
    set /a LINES=LINES+1    
)

rem echo Total Lines : %LINES%
rem echo.

:: n = 3 , last 3 line will be ignored 
set /a LINES=LINES-3

call:PrintFirstNLine > GLM%ncshortfilename1%_3.txt

goto EOF

:PrintFirstNLine
set cur=0
for /f "delims==" %%I in (GLM%ncshortfilename1%.txt) do (      
    echo %%I        
    ::echo !cur! : %%I      
    set /a cur=cur+1    
    if "!cur!"=="%LINES%" goto EOF
) 

:EOF