@echo off
echo import of LSA-SAF MLE (Latent Heat Fluxes) product for full MSG window 
echo MSG at 0 degree
echo temporal resolution 30 minutes
echo file name expected is S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_202003250530.bz2
echo unit is W/m, scaling factor of 10 is applied


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*


copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_%shortfilename1%.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_%shortfilename1%.bz2" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_%shortfilename1%.bz2

"%gdalDir%\gdal_translate" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_%shortfilename1%"://MLE "%OutputDrive%\%OutputDir%\temp_MLE"


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\temp_MLE.mpr %UtilDir%\fcc0000;



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_MLE_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_MLE ge 0,%OutputDrive%\%OutputDir%\temp_MLE/10,?)



del temp_mle.mp*
del *.xml
del S-LSA_-HDF5_LSASAF_MSG_MLE_MSG-Disk_*.*

:END
"%IlwDir%\ilwis.exe" -C closeall