@echo off
echo Snow Cover Africa 

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDir%*

copy %InputDrive%\%InputDir%\"S-LSA_-HDF5_LSASAF_MSG_SC2_NAfr_%shortfilename1%.bz2" 
copy %InputDrive%\%InputDir%\"S-LSA_-HDF5_LSASAF_MSG_SC2_SAfr_%shortfilename1%.bz2" 

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_SC2_NAfr_%shortfilename1%.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_SC2_SAfr_%shortfilename1%.bz2" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_SC2_*Afr_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_SC2_NAfr_%shortfilename1%.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_SC2_SAfr_%shortfilename1%.bz2


"%gdalDir%\gdal_translate.exe" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_SC2_NAfr_%shortfilename1%"://sc "%OutputDrive%\%OutputDir%\nafr_%shortfilename1%"
"%gdalDir%\gdal_translate.exe" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_SC2_SAfr_%shortfilename1%"://sc "%OutputDrive%\%OutputDir%\safr_%shortfilename1%"


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\nafr_%shortfilename1%.mpr %UtilDir%\lst_north;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\safr_%shortfilename1%.mpr %UtilDir%\lst_south;


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\fSC_africa%shortfilename1%.mpr:=MapGlue('%UtilDir%\lst_whole'.grf,%OutputDrive%\%OutputDir%\nafr_%shortfilename1%,%OutputDrive%\%OutputDir%\safr_%shortfilename1%,replace)


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_cSC_Africa%shortfilename1%.mpr{dom='%UtilDir%\saf_snow'}:=MapSlicing(%OutputDrive%\%OutputDir%\fSC_Africa%shortfilename1%.mpr,'%UtilDir%\saf_snow');


del *.xml
del S-LSA_-HDF5_LSASAF_MSG_SC2_NAfr_*.*
del S-LSA_-HDF5_LSASAF_MSG_SC2_SAfr_*.*

del fSC_Africa%shortfilename1%.*
del nafr_%shortfilename1%.*
del safr_%shortfilename1%.*

:END
"%IlwDir%\ilwis.exe" -C closeall