@echo off
echo Ascat Surface Soil Moisture product import routine
echo For both METOP A and METOP B ASCAT SSM-products
echo File name convention: W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,METOPA+ASCAT_C_EUMP_20120819064201_30269_eps_o_125_ssm_l2.bin
echo File name convention: W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,METOPB+ASCAT_C_EUMC_20130218095401_02184_eps_t_125_ssm_l2.bin
rem echo File name convention: W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,METOPB+ASCAT_C_EUMP_20200324174200_38999_eps_o_125_ssm_l2.bin
echo Product relevant for top 5 cm of soil column
echo Output point map is estimate of water saturation from 0-100%
echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~64,20%

set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

rem echo %longfilename:~49,1%


echo Your working directory = %OutputDrive%\%OutputDir%*

copy %InputDrive%\%InputDir%\%longfilename% 
ren %longfilename% METOP%shortfilename3%_ASCAT_%shortfilename1%.bin


if exist "%OutputDrive%\%OutputDir%\METOP_ASCAT_%shortfilename1%.bin" GOTO START 

if not exist "%OutputDrive%\%OutputDir%\METOP_ASCAT_%shortfilename1%.bin" goto MESSAGE



GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp and orbit number used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
echo The file(s) "%InputDrive%\%InputDir%\%longfilename%" will be copied to your current working directory
echo.
echo.

ren "%OutputDrive%\%OutputDir%\METOP_ASCAT_%shortfilename1%.bin" ssm_temp

echo.
echo.
echo Renamed input file = SSM_temp
echo.
echo.


copy SSM_temp "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe SSM_temp -oddump.csv >NUL 2>NUL

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\SSM_temp"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 15 14 66 67 75 79 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS 
echo.



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\ssm_ascat%shortfilename1%_metop%longfilename:~49,1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-180:180:0.00001}),Y(value.dom{-90:90:0.00001}),SM_perc(value.dom{0:100:0.01}),Error_perc(value.dom{0:100:0.01}),Mean_SM(value.dom{0:100:0.0001}),Quality(value.dom{0:100:1}));
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\ssm_ascat%shortfilename1%_smperc_metop%longfilename:~49,1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\ssm_ascat%shortfilename1%_metop%longfilename:~49,1%,LatlonWGS84,SM_perc);


del ssm_temp
del dump*.csv
del ConvertCSV.class



:END
"%IlwDir%\ilwis.exe" -C closeall