@echo off
echo MPEF ASR-import BUFR Import and Processing (All Sky Radiance)
echo Use is made of the MSG projection 
echo Data is resampled from point to grid using a grid resolution of 48 km
echo.
rem new file name: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+ASR_C_EUMG_20221002054500_1.bin
echo Note that import can take some time as large number of record need to be processed
echo Be patient as various columns in a table are being calculated
echo For quick visualization of the ASR file use BUFRDisplay
echo Relevant coordinate variables are: 12-latitude, 13-longitude 
echo Relevant parameters are: 77 (Tb)
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+ASR_C_EUMG_%shortfilename1%00_1.bin" 

if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+ASR_C_EUMG_%shortfilename1%00_1.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+ASR_C_EUMG_%shortfilename1%00_1.bin" will be copied to your current working directory
echo.
echo.

GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

rename "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+ASR_C_EUMG_%shortfilename1%00_1.bin" ASR%shortfilename1%

echo.
echo.
echo Renamed input file = ASR%shortfilename1%
echo.
echo.


copy ASR%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe ASR%shortfilename1% -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\ASR%shortfilename1%"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 14 13 78 < dump2.csv > dump3.csv 


echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo.



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\asr_%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-90:180:0.00001}),Y(value.dom{-90:90:0.00001}),BrightnessT(value.dom{0:500:0.01}))

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\asr_points%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\asr_%shortfilename1%,X,Y,LatlonWGS84,BrightnessT)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\asr_grid%shortfilename1%.mpr{dom=value;vr=0:100}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\asr_points%shortfilename1%,'%UtilDir%\msg_0degree_3km'.grf,16)



del asr%shortfilename1%
del dump*.csv
del ConvertCSV.class


:END
"%IlwDir%\ilwis.exe" -C closeall