@echo off
echo Extract MSG-based fire product (FIRC), CAP format (Common Alert Protocol) - XML
rem new name: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+FIRC_C_EUMG_20221002210000_1.txt

echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+FIRC_C_EUMG_%shortfilename1%00_1.txt" 


:START1
if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+FIRC_C_EUMG_%shortfilename1%00_1.txt"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+FIRC_C_EUMG_%shortfilename1%00_1.txt" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

ren "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+FIRC_C_EUMG_%shortfilename1%00_1.txt" "firc_%shortfilename1%.txt"

"%UtilDir%\ConvertFIRCV1.jar" "%OutputDrive%\%OutputDir%\firc_%shortfilename1%.txt"

if not exist "%OutputDrive%\%OutputDir%\firc_%shortfilename1%Likely.csv" GOTO POSSIBLE

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_likely%shortfilename1%.tbt=table('%OutputDrive%\%OutputDir%\firc_%shortfilename1%Likely'.csv,Comma,Convert,none,Y(value.dom{-90.0000:90.0000:0.0001}),X(value.dom{-180.0000:180.0000:0.0001}),Radius(value.dom{0.0000:500.0000:0.0001}))
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_likely%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\FIRC_likely%shortfilename1%,LatlonWGS84,Radius)

:POSSIBLE

if not exist "%OutputDrive%\%OutputDir%\firc_%shortfilename1%Possible.csv" GOTO END

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_possible%shortfilename1%.tbt=table('%OutputDrive%\%OutputDir%\firc_%shortfilename1%Possible'.csv,Comma,Convert,none,Y(value.dom{-90.0000:90.0000:0.0001}),X(value.dom{-180.0000:180.0000:0.0001}),Radius(value.dom{0.0000:500.0000:0.0001}))
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_possible%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\FIRC_possible%shortfilename1%,LatlonWGS84,Radius)


del firc_%shortfilename1%.txt 
del firc_%shortfilename1%*.csv 


:END
"%IlwDir%\ilwis.exe" -C closeall