@echo off
rem Import selected MeteorM_n2 MTVZA-GY microwave imager level 1 brightness temperature channels (Kelvin)
rem gdal import as xyz ascii
rem data is in orbit geometric configuration
rem resampled to latlonWGS84
rem channels relevant for rainfall detection are retrieved
rem file name convention m_m2_tb_170313_0014_13895_2_09a.hdf

set longfilename=%1
set shortfilename1=%longfilename:~2,6%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set orbitnumber=%9

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*
rem echo *%orbitnumber:~1,5%*
rem echo "%InputDrive%\%InputDir%\m_m2_tb_%shortfilename1%_%shortfilename2%_%orbitnumber:~1,5%_*.hdf"


copy "%InputDrive%\%InputDir%\m_m2_tb_%shortfilename1%_%shortfilename2%_%orbitnumber:~1,5%_*.hdf" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\m_m2_tb_%shortfilename1%_%shortfilename2%_%orbitnumber:~1,5%_*.hdf" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\m_m2_tb_20%shortfilename1%_%shortfilename2%_%orbitnumber:~1,5%_*.hdf" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
rem file name convention m_m2_tb_170313_0014_13895_2_09a.hdf
rename m_m2_tb_%shortfilename1%_%shortfilename2%_%orbitnumber:~1,5%_*.hdf m_m2_tb_20%shortfilename1%%shortfilename2%.hdf

echo importing various channels

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":2 lat.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":3 lon.xyz

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":7 c10_6V.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":8 c10_6H.xyz

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":9 c18_7V.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":10 c18_7H.xyz

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":11 c23_8V.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":12 c23_8H.xyz

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":13 c36_7V.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":14 c36_7H.xyz

"%GdalDir%\gdal_translate.exe" -of xyz -q HDF4_SDS:UNKNOWN:"m_m2_tb_20%shortfilename1%%shortfilename2%.hdf":15 c91_65V.xyz


echo transforming data into ILWIS format - please be patient


rem import tables in ilwis


"%IlwDir%\ilwis.exe" -C latxyz.tbt=table(lat.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),Y(value.dom{-90:90:0.000000001}))
"%IlwDir%\ilwis.exe" -C m_m2_tb_20%shortfilename1%%shortfilename2%.tbt=table(lon.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),X(value.dom{-180:180:0.000000001}))

"%IlwDir%\ilwis.exe" -C c10_6V_xyz.tbt=table(c10_6V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c10_6V(value.dom{0:50000:1}))
"%IlwDir%\ilwis.exe" -C c10_6H_xyz.tbt=table(c10_6H.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c10_6H(value.dom{0:50000:1}))

"%IlwDir%\ilwis.exe" -C c18_7V_xyz.tbt=table(c18_7V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c18_7V(value.dom{0:50000:1}))
"%IlwDir%\ilwis.exe" -C c18_7H_xyz.tbt=table(c18_7V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c18_7H(value.dom{0:50000:1}))

"%IlwDir%\ilwis.exe" -C c23_8V_xyz.tbt=table(c23_8V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c23_8V(value.dom{0:50000:1}))
"%IlwDir%\ilwis.exe" -C c23_8H_xyz.tbt=table(c23_8V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c23_8H(value.dom{0:50000:1}))

"%IlwDir%\ilwis.exe" -C c36_7V_xyz.tbt=table(c36_7V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c36_7V(value.dom{0:50000:1}))
"%IlwDir%\ilwis.exe" -C c36_7H_xyz.tbt=table(c36_7V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c36_7H(value.dom{0:50000:1}))

"%IlwDir%\ilwis.exe" -C c91_65V_xyz.tbt=table(c91_65V.xyz,Space,Convert,none,c1(value.dom{0:200:0.01}),c2(value.dom{0:1500:0.01}),c91_65V(value.dom{0:50000:1}))

echo joining tables and converting to Bt

rem use table m_m2_tb_20%shortfilename1%%shortfilename2% as first table and join other tables

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt Y:=ColumnJoin(latxyz.tbt,Y)

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c10_6V:=ColumnJoin(c10_6V_xyz.tbt,c10_6V)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c10_6V_Bt:=c10_6V/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c10_6H:=ColumnJoin(c10_6H_xyz.tbt,c10_6H)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c10_6H_Bt:=c10_6H/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c18_7V:=ColumnJoin(c18_7V_xyz.tbt,c18_7V)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c18_7V_Bt:=c18_7V/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c18_7H:=ColumnJoin(c18_7H_xyz.tbt,c18_7H)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c18_7H_Bt:=c18_7H/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c23_8V:=ColumnJoin(c23_8V_xyz.tbt,c23_8V)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c23_8V_Bt:=c23_8V/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c23_8H:=ColumnJoin(c23_8H_xyz.tbt,c23_8H)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c23_8H_Bt:=c23_8H/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c36_7V:=ColumnJoin(c36_7V_xyz.tbt,c36_7V)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c36_7V_Bt:=c36_7V/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c36_7H:=ColumnJoin(c36_7H_xyz.tbt,c36_7H)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c36_7H_Bt:=c36_7H/100

"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c91_65V:=ColumnJoin(c91_65V_xyz.tbt,c91_65V)
"%IlwDir%\ilwis.exe" -C tabcalc m_m2_tb_20%shortfilename1%%shortfilename2%.tbt c91_65V_Bt:=c91_65V/100


echo removing obsolete columns

"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c1
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c2
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c10_6V
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c10_6H
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c18_7V
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c18_7H
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c23_8V
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c23_8H
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c36_7V
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c36_7H
"%IlwDir%\ilwis.exe" -C delcol %OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.tbt.c91_65V



echo converting table to point and raster maps

"%IlwDir%\ilwis.exe" -C m_m2_c10_6V_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c10_6V_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c10_6V_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c10_6V_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c10_6H_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c10_6H_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c10_6H_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c10_6H_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c18_7V_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c18_7V_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c18_7V_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c18_7V_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c18_7H_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c18_7H_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c18_7H_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c18_7H_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c23_8V_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c23_8V_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c23_8V_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c23_8V_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c23_8H_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c23_8H_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c23_8H_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c23_8H_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c36_7V_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c36_7V_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c36_7V_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c36_7V_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c36_7H_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c36_7H_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c36_7H_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c36_7H_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)

"%IlwDir%\ilwis.exe" -C m_m2_c91_65V_bt_20%shortfilename1%%shortfilename2%.mpp:=PointMapFromTable(m_m2_tb_20%shortfilename1%%shortfilename2%,LatlonWGS84,c91_65V_Bt)
"%IlwDir%\ilwis.exe" -C m_m2_c91_65V_bt_20%shortfilename1%%shortfilename2%.mpr{dom=value;vr=0:500:0.01}:=MapRasterizePoint(m_m2_c91_65V_bt_20%shortfilename1%%shortfilename2%,meteor_M_N2.grf,1)


rem delete obsolete objects

del "%OutputDrive%\%OutputDir%\m_m2_tb_20%shortfilename1%%shortfilename2%.hdf"
del "%OutputDrive%\%OutputDir%\c23_8V.*"
del "%OutputDrive%\%OutputDir%\c91_65V.*"
del "%OutputDrive%\%OutputDir%\c36_7V.*"
del "%OutputDrive%\%OutputDir%\c23_8H.*"
del "%OutputDrive%\%OutputDir%\c36_7H.*"

del "%OutputDrive%\%OutputDir%\c10_6V.*"
del "%OutputDrive%\%OutputDir%\c10_6H.*"
del "%OutputDrive%\%OutputDir%\c18_7V.*"
del "%OutputDrive%\%OutputDir%\c18_7H.*"

del "%OutputDrive%\%OutputDir%\c23_8V_xyz.*"
del "%OutputDrive%\%OutputDir%\c91_65V_xyz.*"
del "%OutputDrive%\%OutputDir%\c36_7V_xyz.*"
del "%OutputDrive%\%OutputDir%\c23_8H_xyz.*"
del "%OutputDrive%\%OutputDir%\c36_7H_xyz.*"

del "%OutputDrive%\%OutputDir%\c10_6V_xyz.*"
del "%OutputDrive%\%OutputDir%\c10_6H_xyz.*"
del "%OutputDrive%\%OutputDir%\c18_7V_xyz.*"
del "%OutputDrive%\%OutputDir%\c18_7H_xyz.*"


del "%OutputDrive%\%OutputDir%\latxyz.*"
del "%OutputDrive%\%OutputDir%\lat.xyz"
del "%OutputDrive%\%OutputDir%\lon.xyz"

:END
"%IlwDir%\ilwis.exe" -C closeall


