@echo off 
echo Convective rain rate Import
echo From Nowcasting SAF
echo For full MSG disk
echo At full MSG temporal resolution
rem Filename convention S_NWC_CRR_MSG4_global-VISIR_20190618T094500Z.nc


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\S_NWC_CRR_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" "%OutputDrive%\%OutputDir%\*.*"

set MSG_number=2
if exist "%InputDrive%\%InputDir%\S_NWC_CRR_MSG2_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=3
if exist "%InputDrive%\%InputDir%\S_NWC_CRR_MSG3_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=4


:START
if not exist "%OutputDrive%\%OutputDir%\S_NWC_CRR_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S_NWC_CRR_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START1

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%%shortfilename2%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START1

echo.
rem Convective Rain Rate Import
echo.

ren S_NWC_CRR_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc NWC_CRR_%shortfilename1%%shortfilename2%.nc
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"NWC_CRR_%shortfilename1%%shortfilename2%.nc"://crr_intensity %OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\fcc0000'.grf; 


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CRR_intensity_%shortfilename1%%shortfilename2%'.mpr:=iff('%OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%' gt 0,'%OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%' * 0.1,?)

del "%OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\NWC_CRR_temp_%shortfilename1%%shortfilename2%.mp*"
del "%OutputDrive%\%OutputDir%\NWC_CRR_%shortfilename1%%shortfilename2%.nc"

:END
"%IlwDir%\ilwis.exe" -C closeall