@echo off 
echo Mean Diffuse Attenuation Coefficient at 490nm
echo Kd_490 standard_name: volume attenuation coefficient of downwelling radiative flux in sea water
echo Kd_490 units = m-1
echo filename convention PML_Nigeria_MODIS_oc_refined_20110330125000.nc.bz2



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the timestamp of your data file

pause

GOTO END

:START


"%UtilDir%\7z" e PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc":Kd_490 %OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_oc_refined_%shortfilename1%_Kd_490.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_oc_refined_%shortfilename1%_Kd_490.mpr %UtilDir%\pml_modis_Nigeria.grf;

del PML_Nigeria_MODIS_oc_refined_%shortfilename1%_Kd_490.csy
del PML_Nigeria_MODIS_oc_refined_%shortfilename1%_Kd_490.grf
del PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc.bz2
del PML_Nigeria_MODIS_oc_refined_%shortfilename1%00.nc
del PML_Nigeria_MODIS_oc_refined_%shortfilename1%_Kd_490.mpr.aux.xml


:END
"%IlwDir%\ilwis.exe" -C closeall