@echo off
echo Import routine for the Copernicus Fapar 300m OLCI product
echo Yearmonthdekad timestamp is required
echo Temporal resolution is once per 10 days 
echo dekad 1 = 10, dekad 2 = 20 and dekad 3 = last day of the month
echo current version is 2.0.1
echo File name format c_gls_FAPAR300-RT0_202202200000_SOAM_OLCI_V1.1.2.zip
echo Data available from start 2021 onwards
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your current time stamp = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.zip"  goto MESSAGE
echo The file c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.zip is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the source folder specified
echo Your source folder specified is %InputDrive%\%InputDir%
echo The input file was not found.
echo Check your directory and date stamp settings
echo.
echo Your source folder specified is %InputDrive%\%InputDir%
echo Your current date stamp used is %shortfilename1%
echo Check also manually if the data exists on your input directory - archive 
echo Note the temporal resolution of your data is once a day


pause

GOTO END

:START

rem Import NDVI to ilwis

copy "%InputDrive%\%InputDir%\c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.zip"

ren c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.zip Fapar_%shortfilename1%_SOAM.ZIP

%UtilDir%\7z e Fapar_%shortfilename1%_SOAM.ZIP %shortfilename1%/c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.nc



ren c_gls_FAPAR300-RT0_%shortfilename1%0000_SOAM_OLCI_V*.nc Fapar_OLCI_%shortfilename1%.nc

"%GdalDir%\gdal_translate.exe" -of ilwis -q HDF5:"Fapar_OLCI_%shortfilename1%.nc"://FAPAR fapar_org.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\fapar_org'.mpr '%UtilDir%\ndv_soam_olci300m_pc';

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\fapar_OLCI%shortfilename1%_SOAM'.mpr{dom=value;vr=0.000:100.000:0.001}:=iff('%OutputDrive%\%OutputDir%\fapar_org' lt 255,'%OutputDrive%\%OutputDir%\fapar_org'*0.004,?);




del Fapar_org.mp*
del Fapar_OLCI_%shortfilename1%.nc
del Fapar_%shortfilename1%_SOAM.ZIP



:END
"%IlwDir%\ilwis.exe" -C closeall