@echo off
echo Import routine for the Copernicus NDVI 300m OLCI product
echo Yearmonthdekad timestamp is required
echo Temporal resolution is once per 10 days 
echo dekad 1 = 01, dekad 2 = 11 and dekad 3 = 21
echo current version is 2.0.1
echo File name format c_gls_NDVI300_202101010000_AFRI_OLCI_V2.0.1.zip
echo Data available from start 2021 onwards
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your current time stamp = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V2.0.1.zip"  goto MESSAGE
echo The file c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V2.0.1.zip is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the source folder specified
echo Your source folder specified is %InputDrive%\%InputDir%
echo The input file was not found.
echo Check your directory and date stamp settings
echo.
echo Your source folder specified is %InputDrive%\%InputDir%
echo Your current date stamp used is %shortfilename1%
echo Check also manually if the data exists on your input directory - archive 
echo Note the temporal resolution of your data is once a day


pause

GOTO END

:START

rem Import NDVI to ilwis

copy "%InputDrive%\%InputDir%\c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V2.0.1.zip"

ren c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V*.zip NDVI_OLCI_%shortfilename1%_AFRI.ZIP

%UtilDir%\7z e NDVI_OLCI_%shortfilename1%_AFRI.ZIP %shortfilename1%/c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V*.nc



ren c_gls_NDVI300_%shortfilename1%0000_AFRI_OLCI_V*.nc NDVI_OLCI_%shortfilename1%.nc

"%GdalDir%\gdal_translate.exe" -of ilwis -q HDF5:"NDVI_OLCI_%shortfilename1%.nc"://NDVI ndv_org.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\ndv_org'.mpr '%UtilDir%\ndv_afr_olci300m_pc';
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ndvi_OLCI%shortfilename1%_Afri'.mpr{dom=value;vr=0.000:0.92:0.001}:=('%OutputDrive%\%OutputDir%\ndv_org'/250-0.08);




del ndv_org.mp*
del NDVI_OLCI_%shortfilename1%.nc
del NDVI_OLCI_%shortfilename1%_AFRI.ZIP



:END
"%IlwDir%\ilwis.exe" -C closeall