@echo off
echo Extract NOAA STAR 
echo Archive used is ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/

echo After extraction file name is VHP.G04.C07.npp.P1981035.SM.SMN.tif and VHP.G04.C07.npp.P1981035.SM.SMT.tif	
echo Data extracted for a week numbered 001 to 052!
echo Weekly time interval!
echo NOAA 19 (NP) - AVHRR instrument used
echo smoothed ndvi scaled from -0.1 to 1 and smoothed temperature from 0-400 Kelvin


rem file name convention VHP.G04.C07.npp.P1981035.SM.SMN.tif and VHP.G04.C07.npp.P1981035.SM.SMT.tif


echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set shortfilename2=%longfilename:~4,3%
set OutputDrive=%4
set OutputDir=%5
set GdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.





"%UtilDir%\wget\wget.exe" ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMN.tif
"%UtilDir%\wget\wget.exe" ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMT.tif


echo off
if not exist "%OutputDrive%\%OutputDir%\VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMT.tif"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMN.tif"  goto MESSAGE
echo The file(s) "VHP.G04.C07.NP.P%shortfilename1%%shortfilename2%.SM" have been retrieved and transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%%shortfilename2%
echo Data is retrieved from ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/
echo Check also manually if the data exists on ftp archive (see link above)
echo Internet has a transient nature - addresses might not be valid or has changed after some time!


pause

GOTO END

:START
ren VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMT.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.tif
ren VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM.SMN.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.tif

"%GdalDir%\gdal_translate.exe" -of ilwis STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.mpr

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMT:=iff(%OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT ge 0, %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMN:=iff(%OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN ge 0, %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN,?)

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMT.mpr %utildir%\star_vhp.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMN.mpr %utildir%\star_vhp.grf;


del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.tif
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.tif 
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.mp*
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.mp*
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.grf
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMN.csy
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.grf
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_SMT.csy



:END
"%IlwDir%\ilwis.exe" -C closeall